set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '0141411',
      81.737556,
      NULL,
      NULL,
      3,
      '000302',
      0,
      ' 4- 6-1999',
      10,
      NULL,
      NULL,
      NULL,
      0.770029,
      0.514622,
      0,
      1.730477,
      1.217688,
      0.817018,
      NULL,
      NULL,
      1.484339,
      1.941099,
      0.842120,
      0,
      NULL,
      0.372214,
      0,
      NULL,
      0.791526,
      NULL,
      0,
      1.032487,
      1.366894,
      1,
      3.921347,
      NULL,
      3,
      0.960583,
      1,
      NULL,
      NULL,
      NULL,
      0.795149,
      NULL,
      NULL,
      0.021057,
      0.455426,
      0,
      0.428132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.213290,
      1,
      0,
      1.903467,
      0.878896,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.582240,
      1,
      4.700985,
      3,
      4.167142,
      3.672136,
      1.783158,
      0,
      1,
      5,
      NULL,
      0,
      1.858412,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.503815,
      1,
      NULL,
      0.052744,
      0.192169,
      NULL,
      1,
      0,
      1,
      1.217653,
      0.788446,
      1,
      1.146295,
      0,
      6,
      0.765276,
      4,
      1.631672,
      7,
      5.481349,
      5.787351,
      7,
      1,
      0.268914,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672551,
      3,
      0,
      1,
      1.585297,
      1.552312,
      1.842490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003096,
      0.223885,
      1.660108,
      0,
      0,
      1.144470,
      0,
      NULL,
      1.452470,
      7,
      NULL,
      0.862581,
      NULL,
      NULL,
      NULL,
      0.730252,
      5,
      0,
      3,
      NULL,
      1,
      2,
      1.764720,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634966,
      NULL,
      0,
      NULL,
      2,
      1.729840,
      NULL,
      NULL,
      0,
      3.757794,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.181540,
      1.344197,
      0.036777,
      0.496888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '31114',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


