set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      60.339674,
      NULL,
      0,
      3,
      '101141',
      NULL,
      ' 7-25-1991',
      NULL,
      NULL,
      1.898989,
      NULL,
      NULL,
      0,
      0.891014,
      1,
      0.199464,
      0.516152,
      NULL,
      NULL,
      NULL,
      NULL,
      2.932492,
      1.794510,
      1,
      1,
      1,
      NULL,
      5.933379,
      1.541173,
      1.080312,
      NULL,
      0.318182,
      0,
      3,
      NULL,
      2,
      1,
      0,
      1.311816,
      NULL,
      NULL,
      0.915329,
      NULL,
      NULL,
      1.388050,
      0.533612,
      0.303530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.283558,
      NULL,
      1,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      5,
      3.378672,
      1,
      3,
      0,
      1,
      NULL,
      0,
      1.006253,
      NULL,
      1,
      1,
      NULL,
      1,
      0.237423,
      1,
      NULL,
      NULL,
      0.815293,
      1.480294,
      0.327443,
      NULL,
      NULL,
      0,
      0.403212,
      0.131674,
      4.918864,
      6.391214,
      2,
      4.835349,
      7.220455,
      3,
      0.491568,
      6,
      NULL,
      0.235889,
      0,
      0.127462,
      NULL,
      NULL,
      NULL,
      9,
      0.904175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993360,
      5,
      NULL,
      NULL,
      0,
      1,
      1.225380,
      1.049459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712047,
      NULL,
      2,
      3.960551,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.397315,
      4,
      5,
      1.335059,
      0,
      NULL,
      NULL,
      NULL,
      5.904191,
      1.058483,
      5,
      5.276811,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322409,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.184217,
      1,
      NULL,
      2.140705,
      NULL,
      1.856349,
      1,
      2,
      1.861664,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1.162986,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '02012',
      '',
      '',
      1.347450,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


