set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '33',
      7,
      NULL,
      '2102300',
      214.216970,
      5,
      1.087867,
      1,
      NULL,
      3.028497,
      ' 4- 8-2003',
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      0,
      1,
      0.075622,
      2.412945,
      NULL,
      0,
      0,
      NULL,
      0,
      0.707123,
      0,
      0,
      0.344710,
      0.720174,
      1.340156,
      1,
      1.572231,
      0.695065,
      0,
      0,
      1.100597,
      1.713678,
      NULL,
      NULL,
      NULL,
      1.180985,
      NULL,
      NULL,
      0,
      1,
      0.642000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.434003,
      1.601675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.098840,
      0,
      2.813792,
      4,
      1.075465,
      4,
      0,
      0,
      0.067111,
      1.171887,
      0,
      NULL,
      1.513141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239576,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      0.604113,
      1.480907,
      0,
      0,
      NULL,
      1,
      2,
      5.189276,
      3,
      6,
      5,
      NULL,
      6.107230,
      7.114451,
      6.126739,
      1.363375,
      1.141235,
      NULL,
      1,
      NULL,
      NULL,
      5.879376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143627,
      1.131916,
      0,
      1,
      1.272747,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.540074,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.383298,
      0,
      0.017103,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.773270,
      0,
      0.747953,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.229818,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      2.126252,
      2,
      1,
      0,
      0.255346,
      0,
      2,
      0,
      NULL,
      1.628810,
      1.522681,
      1.436693,
      1.482993,
      0.709726,
      1,
      1.208574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      '2433',
      '3224',
      '',
      3.492689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


