set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42',
      24.911679,
      NULL,
      '2402243',
      145.787852,
      1,
      1,
      0,
      '100341',
      NULL,
      '11-11-2001',
      NULL,
      51,
      1.932239,
      NULL,
      0.054884,
      2,
      0.847712,
      1,
      1.550959,
      0,
      0.984613,
      1,
      1,
      0.552160,
      NULL,
      0.516762,
      0,
      NULL,
      1,
      0.679099,
      2,
      0,
      1.719581,
      0,
      0.512254,
      1.969671,
      1.349661,
      1,
      1,
      0,
      0.455443,
      NULL,
      NULL,
      NULL,
      0.677765,
      NULL,
      NULL,
      1,
      NULL,
      1.203715,
      0.199790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.283521,
      3,
      1.520197,
      5,
      NULL,
      0.491562,
      0.404891,
      0.864179,
      0,
      NULL,
      1.128072,
      0.480196,
      4.114903,
      NULL,
      0.627401,
      1.955759,
      1,
      1.601914,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.725651,
      1,
      NULL,
      2.348367,
      1.774493,
      1,
      0,
      NULL,
      0,
      4.906227,
      1.023195,
      1,
      NULL,
      4.025932,
      4.697201,
      NULL,
      2.236354,
      4,
      6,
      1.529668,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422959,
      0,
      0,
      1,
      0.936253,
      1.996257,
      0.696703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.830134,
      NULL,
      9,
      NULL,
      3.567951,
      0.018017,
      3.617641,
      NULL,
      0.465830,
      0,
      NULL,
      6.405705,
      2.578894,
      0.396258,
      NULL,
      NULL,
      NULL,
      5,
      1.063732,
      5,
      3.716619,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.152836,
      NULL,
      NULL,
      4,
      1,
      2,
      7.727730,
      NULL,
      0,
      0.542449,
      1.753963,
      2,
      NULL,
      3,
      3,
      NULL,
      1,
      0.280993,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      0,
      1.481790,
      0,
      0.206398,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.578792,
      '20224',
      '',
      '',
      0.525377,
      '',
      '',
      '',
      2.835433,
      '20004',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


