set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '42',
      28,
      20.111054,
      '2400433',
      196,
      4,
      NULL,
      NULL,
      '434040',
      5.337160,
      ' 5-18-1979',
      1,
      40,
      1.830591,
      NULL,
      1.915697,
      3,
      0,
      0,
      NULL,
      0.695921,
      2.262952,
      1.466982,
      1,
      1.599056,
      3,
      1,
      1.543267,
      0.870795,
      0.023589,
      0.517172,
      4.267897,
      0.807551,
      0,
      NULL,
      NULL,
      1.534762,
      5,
      NULL,
      3,
      1,
      0,
      1.677463,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.454105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.949257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778639,
      NULL,
      0,
      0.389952,
      1,
      3,
      0.594830,
      0,
      1.622019,
      1.154409,
      NULL,
      5,
      0,
      2.229072,
      1,
      1,
      0,
      1.334731,
      1.085971,
      NULL,
      NULL,
      NULL,
      0,
      1.065656,
      0,
      0,
      1.594736,
      NULL,
      0,
      0.658039,
      1,
      1,
      0.287057,
      NULL,
      1.616348,
      0,
      NULL,
      2.058008,
      5.368184,
      5,
      NULL,
      3.897538,
      0.791498,
      0.934647,
      NULL,
      3,
      4.088864,
      NULL,
      0.781427,
      NULL,
      NULL,
      6.789602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345765,
      0,
      0,
      1,
      1.195540,
      1,
      1.522933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597546,
      NULL,
      9,
      NULL,
      NULL,
      0.102028,
      3.132272,
      1.031272,
      1,
      1,
      NULL,
      NULL,
      1.836202,
      1.503704,
      NULL,
      NULL,
      NULL,
      3,
      0.520354,
      5.005030,
      1,
      3.213390,
      0,
      NULL,
      0.248792,
      NULL,
      NULL,
      1.227447,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.710939,
      1.334964,
      0,
      NULL,
      1,
      1.017758,
      0.189261,
      1.172452,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1.936225,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


