set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40',
      NULL,
      9,
      NULL,
      268,
      6,
      1,
      NULL,
      NULL,
      1.784209,
      ' 0- 9-2001',
      11.326993,
      NULL,
      NULL,
      NULL,
      0.992817,
      2.048782,
      1.299476,
      0,
      0.328266,
      NULL,
      2.244912,
      1,
      0,
      1.324895,
      3.003122,
      NULL,
      0,
      0,
      0.481678,
      1.996552,
      3,
      1,
      NULL,
      1.936528,
      1.397160,
      0.090291,
      1.117873,
      1,
      1.531499,
      0.988319,
      0,
      0.915638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.292533,
      NULL,
      0,
      1.183871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.546422,
      0.162332,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863190,
      1.620881,
      1,
      1.417924,
      NULL,
      NULL,
      0.763667,
      1.191714,
      1,
      1,
      4.640395,
      0,
      0,
      4.511783,
      NULL,
      0,
      0.475967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105900,
      0,
      0,
      0,
      1.268179,
      0.992177,
      1,
      0,
      1.902477,
      NULL,
      1,
      0.534433,
      NULL,
      1,
      1,
      5.842722,
      3.740466,
      1.000601,
      5.230183,
      1.290341,
      NULL,
      6.859004,
      5.741711,
      0,
      1,
      3.908523,
      NULL,
      NULL,
      NULL,
      3.909733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125176,
      4.201931,
      0,
      1,
      1.273746,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      2.546487,
      1.681083,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.179488,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.240230,
      0,
      NULL,
      1.031426,
      2.731859,
      2,
      1.324950,
      NULL,
      NULL,
      NULL,
      1.236194,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733822,
      NULL,
      1.622203,
      3.398036,
      NULL,
      0.208426,
      3,
      0.061223,
      1.272203,
      NULL,
      0.966289,
      1,
      0.043327,
      1,
      NULL,
      1,
      0,
      0,
      0.331196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '32311',
      NULL,
      '',
      0.191835,
      NULL,
      '',
      '',
      0,
      '44223',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


