set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43043424',
      NULL,
      49,
      '4210304',
      94.469094,
      NULL,
      1.800920,
      NULL,
      '320113',
      NULL,
      ' 5-15-1975',
      35.947197,
      29,
      0.112104,
      NULL,
      0.196576,
      1,
      NULL,
      NULL,
      0.098721,
      0,
      1,
      0,
      0.396655,
      0,
      5,
      1,
      0,
      0.897855,
      1.808180,
      1,
      NULL,
      1.585037,
      NULL,
      NULL,
      1,
      1.093896,
      0.739695,
      0,
      NULL,
      0,
      NULL,
      1.695204,
      NULL,
      NULL,
      0.807258,
      NULL,
      NULL,
      0.610003,
      0,
      0,
      1.306990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.891242,
      0.629040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.233376,
      1.909435,
      0,
      NULL,
      NULL,
      1.179464,
      0.860924,
      NULL,
      0,
      NULL,
      4,
      0.752534,
      0,
      0,
      0.596944,
      1.812371,
      NULL,
      0,
      0.010560,
      NULL,
      0,
      1.334069,
      1,
      NULL,
      1.243555,
      NULL,
      1,
      1,
      1,
      1.845676,
      0.048834,
      0.228893,
      NULL,
      0,
      0.278511,
      3.401318,
      5.693358,
      0.638890,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      3.148885,
      0,
      NULL,
      NULL,
      6,
      0.621957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957313,
      1,
      NULL,
      NULL,
      0.855651,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.741554,
      2.745808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064923,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.591172,
      1.063179,
      5.075124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.591305,
      1.347453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836484,
      1.197393,
      0.285658,
      3.708113,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      1.769923,
      1.094411,
      1,
      1.773175,
      0.486804,
      0,
      NULL,
      1.845908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.220326,
      '13132',
      '',
      '',
      1.701216,
      '',
      '',
      '',
      1.120348,
      '14411',
      NULL,
      '',
      1,
      NULL,
      3,
      0.779990,
      0,
      1.738490,
      NULL,
      3,
      0.921359);
commit;
end;
/


