set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '34022423',
      54,
      22,
      '3201344',
      46.037030,
      5,
      1.727740,
      3,
      '034010',
      NULL,
      '10- 5-1997',
      33,
      26,
      0.468624,
      NULL,
      1,
      1.746837,
      0.025195,
      1.438696,
      0.294111,
      NULL,
      0.261468,
      NULL,
      1,
      1.475936,
      2,
      1.175524,
      1.102282,
      1,
      NULL,
      NULL,
      4.961565,
      1,
      0.051211,
      1.652136,
      0.021679,
      0.848177,
      2,
      0,
      0.981510,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.441250,
      NULL,
      NULL,
      1,
      NULL,
      0.330527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933221,
      1.117134,
      1.389098,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338536,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      4,
      2,
      2,
      0,
      0,
      0.449921,
      0,
      1.112264,
      0.932296,
      1.416735,
      NULL,
      0,
      NULL,
      0,
      1.104704,
      NULL,
      1.506387,
      1,
      0.407120,
      0.904621,
      0.002877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.904491,
      7,
      6,
      4,
      9,
      3,
      3,
      NULL,
      4,
      4,
      1.579583,
      0.868490,
      0,
      0.369383,
      NULL,
      NULL,
      8.466871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791528,
      1.450425,
      NULL,
      1,
      1.046852,
      0.474223,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477512,
      NULL,
      5.135344,
      1,
      3.020934,
      5,
      3,
      2,
      0.153845,
      NULL,
      NULL,
      7.260196,
      NULL,
      1.095910,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4.344322,
      1.942773,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.632275,
      6.876265,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.683649,
      0,
      2.936657,
      3.840176,
      NULL,
      1,
      0.039214,
      NULL,
      2.693106,
      0.814388,
      0,
      1.293081,
      0,
      1.998988,
      0,
      0,
      0,
      0.360736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '31121',
      '',
      NULL,
      0.921495,
      '',
      '',
      '',
      1.035876,
      NULL,
      '',
      '',
      2,
      NULL,
      0,
      2,
      2,
      1.207527,
      2,
      0,
      0);
commit;
end;
/


