set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '21043201',
      6.600945,
      37.398076,
      '1342332',
      280.158678,
      5,
      2.844868,
      NULL,
      '211002',
      3.859096,
      ' 8-20-1991',
      28,
      18.968691,
      0.541164,
      NULL,
      1.097375,
      0,
      1,
      0.701215,
      1.994447,
      1,
      0.574330,
      0,
      NULL,
      1.765583,
      0,
      0,
      NULL,
      0.529554,
      NULL,
      1,
      5,
      0.705857,
      1,
      0.675401,
      NULL,
      0.764546,
      NULL,
      0,
      0.761218,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297460,
      0,
      0,
      1.908535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073993,
      NULL,
      0.729189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684478,
      1,
      0,
      1.647402,
      NULL,
      1.587730,
      0.017399,
      0,
      NULL,
      2.495935,
      3,
      3.068407,
      NULL,
      NULL,
      0.170671,
      0,
      1.931561,
      0.460129,
      NULL,
      NULL,
      1.375040,
      1.681065,
      1.098659,
      0,
      1,
      NULL,
      0.138929,
      0,
      0,
      0,
      1.627511,
      1.500118,
      1.007282,
      0.783728,
      1.706917,
      1,
      1,
      0,
      1.892024,
      5.539439,
      4,
      2.322467,
      5.685513,
      4.164295,
      0.285586,
      5,
      3.172336,
      1,
      1,
      NULL,
      NULL,
      3.902300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      2.103171,
      0.410044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402819,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.297586,
      0.195139,
      NULL,
      2.015098,
      2.654618,
      0.390765,
      3.949157,
      0.060962,
      NULL,
      NULL,
      NULL,
      4,
      1.178560,
      1,
      0,
      NULL,
      0,
      1.401670,
      NULL,
      NULL,
      NULL,
      1.433366,
      3.788726,
      1.624048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269734,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.795638,
      0.635713,
      0.881846,
      0.799225,
      1,
      0.549831,
      1,
      0.424273,
      1,
      0,
      0,
      1.225009,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '14133',
      '',
      '',
      1.747301,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3,
      1.548406,
      NULL,
      5.158035,
      NULL,
      0,
      NULL,
      2,
      NULL);
commit;
end;
/


