set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      NULL,
      27,
      38.719820,
      '2441423',
      NULL,
      1,
      3.722952,
      NULL,
      '241000',
      4.098154,
      ' 7- 3-1976',
      7,
      56.346430,
      1,
      NULL,
      0,
      1,
      NULL,
      1.778153,
      NULL,
      NULL,
      NULL,
      0,
      0.802973,
      NULL,
      8,
      1,
      NULL,
      1.465769,
      6,
      3.675939,
      9,
      1,
      0.058352,
      NULL,
      0.666441,
      3,
      5.326822,
      1,
      5,
      4,
      1.600802,
      3.120634,
      2.476198,
      0,
      0.833286,
      NULL,
      NULL,
      1.547797,
      1.862253,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.621315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.314699,
      NULL,
      0.732546,
      1.161450,
      4,
      1.346746,
      0.354650,
      NULL,
      1.057464,
      7.595818,
      7.506963,
      1.666869,
      1.987537,
      2.722963,
      0.253985,
      1,
      NULL,
      1,
      0,
      NULL,
      0.827564,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1.581718,
      0.848351,
      1.575097,
      1.212766,
      NULL,
      1.490835,
      0.840149,
      0.173292,
      6.446003,
      2,
      3.926618,
      3,
      3,
      0,
      0.851460,
      4.479204,
      3.895127,
      3.378355,
      3,
      1,
      0.983234,
      NULL,
      1,
      2,
      NULL,
      4.602712,
      NULL,
      3,
      1,
      4,
      NULL,
      NULL,
      2,
      2.272138,
      3.793555,
      0.008245,
      2,
      0.836573,
      11,
      1.338873,
      1.186586,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.077945,
      0,
      3,
      4.841372,
      2.195741,
      0.901741,
      2,
      2,
      1.548403,
      3,
      4.367257,
      1.407110,
      0,
      1.245309,
      0.085974,
      2,
      1,
      1.823189,
      NULL,
      NULL,
      0,
      5.182893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.027529,
      NULL,
      2,
      0.052489,
      2.974710,
      0,
      0.158077,
      1,
      1.106549,
      1.801189,
      1,
      1,
      NULL,
      NULL,
      1.580477,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.008524,
      '33104',
      '',
      '',
      0.904598,
      '',
      '',
      '',
      5.114926,
      NULL,
      '1243',
      '0142',
      5.085778,
      NULL,
      1.353779,
      3.966928,
      2,
      2.983668,
      NULL,
      2,
      NULL);
commit;
end;
/


