set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0322',
      '01130210',
      8.602951,
      35.284918,
      '3443311',
      NULL,
      6,
      0,
      3,
      NULL,
      6,
      ' 9- 5-1980',
      NULL,
      28.916316,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.048721,
      NULL,
      NULL,
      0.646443,
      0.470632,
      0.310047,
      1.512445,
      9,
      0.985095,
      1.520069,
      NULL,
      1,
      1,
      0.457624,
      1,
      0,
      1.301591,
      NULL,
      0.212286,
      1.983738,
      0,
      0,
      2.465623,
      3,
      0,
      NULL,
      NULL,
      0.693739,
      NULL,
      NULL,
      NULL,
      1,
      1.442612,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242288,
      1.689480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100236,
      1.834563,
      1.347472,
      NULL,
      3.772987,
      NULL,
      0.664732,
      1.706639,
      1.616767,
      7,
      5,
      2,
      1.177121,
      3.659094,
      1,
      1,
      1.252106,
      1.705388,
      1.766693,
      NULL,
      0.417280,
      1.445403,
      0,
      1.974549,
      0.844447,
      1,
      0,
      0,
      0,
      1,
      0.664269,
      NULL,
      0.046040,
      0,
      0.151317,
      1,
      0,
      NULL,
      5,
      1,
      2.154308,
      NULL,
      4.996272,
      4,
      4.415200,
      3.847402,
      NULL,
      NULL,
      1.019242,
      0.960926,
      1.841462,
      3.227275,
      3.277939,
      NULL,
      2,
      NULL,
      0.576594,
      1,
      7.727035,
      2.227165,
      0,
      2,
      NULL,
      7,
      8,
      NULL,
      0.744379,
      NULL,
      2,
      1.243717,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.005846,
      NULL,
      1.705078,
      1.912713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276249,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      2,
      0.049090,
      1,
      1,
      0.675090,
      1.859696,
      1,
      0,
      0.636553,
      0.593552,
      NULL,
      0.347448,
      0.282107,
      0,
      1.008297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.405424,
      '12140',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      7,
      NULL,
      '4113',
      '2030',
      5,
      0,
      NULL,
      3.362727,
      2,
      0,
      NULL,
      NULL,
      1);
commit;
end;
/


