set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      75.692142,
      '4403240',
      116,
      NULL,
      NULL,
      3,
      '001133',
      NULL,
      NULL,
      28.902814,
      43,
      NULL,
      NULL,
      NULL,
      3.788881,
      1.238828,
      0.813452,
      1,
      0,
      1,
      3,
      0.996194,
      NULL,
      2,
      0,
      0,
      2,
      NULL,
      8.780411,
      7,
      1,
      3,
      NULL,
      0,
      2,
      11,
      3,
      0,
      NULL,
      3.356082,
      1,
      NULL,
      5.312411,
      1,
      NULL,
      NULL,
      0.662231,
      1,
      1,
      1.793606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161315,
      0.559999,
      1.837783,
      0.670617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.277839,
      5,
      0,
      1.533715,
      4,
      0.498464,
      1,
      0,
      3.737472,
      3.985093,
      1,
      5,
      0,
      6,
      1.211255,
      1.620915,
      0.107588,
      0,
      0.705236,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.870551,
      1.276507,
      1,
      1.643091,
      1.246570,
      0,
      1,
      0,
      NULL,
      1,
      0.350266,
      2.258786,
      1,
      4.595804,
      1.396102,
      NULL,
      3.050589,
      5.794345,
      NULL,
      0,
      6.877013,
      4,
      4,
      5,
      NULL,
      NULL,
      1,
      0.110019,
      2.770156,
      NULL,
      NULL,
      0,
      1.165177,
      3,
      4,
      0,
      1,
      1,
      5.380162,
      7.312153,
      4,
      7.694912,
      NULL,
      5.988737,
      1.598679,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.128875,
      2.328068,
      NULL,
      2,
      1.632539,
      1.044466,
      0,
      0,
      1,
      1,
      0.900326,
      NULL,
      NULL,
      NULL,
      1.371598,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022009,
      2,
      NULL,
      3,
      3,
      3.680122,
      0,
      NULL,
      NULL,
      0,
      0.460013,
      0,
      0.199870,
      0,
      1.540848,
      0.480153,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      NULL,
      '0014',
      '4324',
      4.146652,
      4.448120,
      NULL,
      3.229558,
      3,
      2.832099,
      2.662716,
      3,
      0.620474);
commit;
end;
/


