set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1434',
      NULL,
      NULL,
      52,
      NULL,
      248.322958,
      4,
      NULL,
      1,
      '033304',
      NULL,
      NULL,
      23,
      42,
      1.722291,
      NULL,
      1,
      1,
      0.861147,
      1.273963,
      0.397202,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.632739,
      NULL,
      1,
      8.017225,
      2,
      1,
      7.949742,
      NULL,
      0.734798,
      0.388466,
      1.493465,
      0.220543,
      9.959557,
      0,
      3.797952,
      3.294675,
      2.550446,
      NULL,
      5.121621,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0.342626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.546594,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.553195,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0.653727,
      0.540348,
      1,
      6.085667,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820659,
      0,
      0.646670,
      NULL,
      1.694833,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264578,
      0,
      1,
      0.086477,
      NULL,
      NULL,
      1,
      0.385538,
      1.269491,
      NULL,
      1.582400,
      1.569922,
      NULL,
      1,
      NULL,
      2,
      1.883399,
      7,
      4,
      5.732452,
      4,
      7,
      0,
      NULL,
      3,
      1.457974,
      NULL,
      1.889752,
      NULL,
      7,
      NULL,
      NULL,
      2.746575,
      2,
      0,
      0.300458,
      NULL,
      0,
      NULL,
      1.933692,
      1,
      5,
      2,
      1,
      NULL,
      1.410287,
      0.847873,
      0.931794,
      0.300731,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.582793,
      0,
      3,
      3,
      NULL,
      1.889185,
      NULL,
      1.850286,
      NULL,
      0,
      1.068245,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.539917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426002,
      0.225136,
      0,
      NULL,
      1,
      0,
      0,
      1.611743,
      1.172459,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1.341178,
      1.209095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '33413',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '12343',
      '4003',
      '0442',
      0.447151,
      NULL,
      1.569134,
      1,
      0,
      5.604424,
      1,
      3.153943,
      0.058714);
commit;
end;
/


