set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '101',
      '03',
      NULL,
      14.184963,
      NULL,
      2,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      27.787116,
      NULL,
      0,
      NULL,
      0.333570,
      NULL,
      3,
      0,
      1.048667,
      0.830060,
      0.619454,
      0,
      0.806066,
      1.366372,
      1.999054,
      0.570315,
      1,
      1,
      1.513016,
      3.482528,
      7,
      1.189974,
      1.178111,
      1.299450,
      3.131263,
      1,
      4.265105,
      0,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.363896,
      NULL,
      NULL,
      1.794766,
      1,
      0.204564,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931350,
      5,
      1,
      1.260309,
      NULL,
      NULL,
      1.009783,
      1,
      0,
      0,
      0,
      NULL,
      0.228638,
      NULL,
      0,
      1,
      0,
      1.226393,
      NULL,
      0.396732,
      0,
      0.873142,
      0,
      1.291149,
      0,
      NULL,
      1.884314,
      4.288269,
      0,
      0.781388,
      NULL,
      5.285514,
      0.432099,
      2,
      0,
      4.415103,
      6.772388,
      0,
      5.550437,
      4,
      1,
      0.242665,
      5,
      NULL,
      1,
      0.972771,
      0.271807,
      1,
      NULL,
      1.333750,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184214,
      0,
      0,
      NULL,
      1.504938,
      0.279022,
      1.677760,
      1.976566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029149,
      NULL,
      NULL,
      NULL,
      NULL,
      3.353673,
      NULL,
      0,
      1.826848,
      1.707178,
      3.405748,
      4.364671,
      1.490591,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.951817,
      1,
      1,
      0.113032,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786436,
      0.431720,
      1,
      NULL,
      3.418878,
      NULL,
      0,
      NULL,
      NULL,
      2.125328,
      2.273583,
      NULL,
      0.621968,
      1,
      1,
      1.757092,
      0.552332,
      1,
      0,
      1.797356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412434,
      NULL,
      '31212',
      '',
      0.705798,
      '',
      NULL,
      NULL,
      0.391532,
      '',
      '',
      '',
      1.757586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


