set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24',
      NULL,
      43.381426,
      '3403044',
      24,
      5,
      NULL,
      1,
      NULL,
      0.238357,
      ' 6-17-2000',
      23,
      55,
      1.909600,
      NULL,
      0.716617,
      1.496566,
      1.487898,
      0,
      0.017810,
      1,
      NULL,
      0.942931,
      3,
      0,
      7.951801,
      1,
      NULL,
      NULL,
      2,
      6,
      NULL,
      10.098619,
      0,
      1,
      9,
      2.167937,
      11,
      3,
      NULL,
      0.039343,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.927015,
      0,
      1.020695,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.266561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942595,
      1,
      NULL,
      1.722736,
      5.655760,
      0,
      1.241859,
      1.673669,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.757361,
      0,
      0.982303,
      1,
      NULL,
      NULL,
      1.847513,
      1,
      0.912797,
      0,
      1.526947,
      0.987902,
      1.140648,
      0.944279,
      2,
      1.822663,
      5.263635,
      NULL,
      4.951968,
      0.966584,
      2.568717,
      3.628604,
      0,
      7,
      3.172047,
      6,
      2.418312,
      NULL,
      NULL,
      7,
      9.283436,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.290749,
      3.964191,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968381,
      1.434182,
      0,
      0,
      0,
      0.629361,
      1.018636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.437984,
      3.636830,
      1,
      0.357462,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      0.131779,
      NULL,
      5.823407,
      NULL,
      NULL,
      NULL,
      0,
      2.751635,
      1.957073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391447,
      3,
      1.591618,
      NULL,
      NULL,
      1.857980,
      2,
      1,
      0.465809,
      NULL,
      1.584748,
      0.516678,
      0,
      NULL,
      1.497278,
      1.767319,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.615733,
      NULL,
      '30012',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.200722,
      NULL,
      NULL,
      '',
      NULL,
      1.811920,
      1,
      0,
      0,
      3.277315,
      1.761669,
      3.358971,
      3);
commit;
end;
/


