set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '20131223',
      9,
      17.737139,
      '1321320',
      5.431166,
      1,
      2.706453,
      0,
      NULL,
      5.539068,
      NULL,
      15.774752,
      36,
      0,
      NULL,
      3.824657,
      NULL,
      1.809650,
      1,
      1,
      2.444943,
      3,
      0.095412,
      0,
      0,
      0.245987,
      0,
      0,
      0,
      3,
      7.502098,
      1.024038,
      1,
      NULL,
      3,
      5,
      6.570363,
      NULL,
      1,
      3.712232,
      0,
      NULL,
      1.251526,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.553692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.198774,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891560,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1.993677,
      0.607003,
      1,
      1,
      1.144387,
      0,
      0.597812,
      1.455110,
      NULL,
      0.264177,
      NULL,
      1,
      1.184083,
      0.794326,
      NULL,
      1.325490,
      NULL,
      5,
      1,
      1.739073,
      0.591198,
      0.555065,
      1,
      5,
      NULL,
      NULL,
      5.142854,
      5.166223,
      NULL,
      2.145840,
      4,
      2.932727,
      NULL,
      NULL,
      0,
      1,
      1.508308,
      3,
      0,
      0.595142,
      NULL,
      0.176653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863178,
      1,
      NULL,
      1.759545,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.310170,
      3,
      NULL,
      NULL,
      1,
      6,
      0,
      0.075815,
      NULL,
      NULL,
      NULL,
      1.037830,
      1,
      0,
      3.914106,
      1,
      0,
      1.924549,
      NULL,
      NULL,
      NULL,
      1.849270,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.749648,
      2.977022,
      NULL,
      2,
      2.291303,
      0,
      2.315435,
      0,
      0.189955,
      0,
      0,
      0.799235,
      NULL,
      1,
      0.139002,
      0.572199,
      0.400063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20010',
      '14223',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      0.560434,
      0.580859,
      NULL,
      NULL,
      3.948703,
      1,
      1,
      3);
commit;
end;
/


