set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      NULL,
      51,
      NULL,
      '1013221',
      34,
      1,
      0,
      1,
      '201004',
      4.583599,
      ' 2-15-1991',
      NULL,
      43.520337,
      0.287370,
      NULL,
      NULL,
      3,
      1,
      1.201580,
      1.125076,
      0,
      NULL,
      0,
      NULL,
      0,
      6,
      0,
      1.970390,
      0.280423,
      2,
      NULL,
      2.057162,
      NULL,
      9.354944,
      1,
      1,
      0.353267,
      2.030000,
      1,
      1.554699,
      2.042419,
      2.143311,
      0,
      NULL,
      NULL,
      1.972902,
      NULL,
      NULL,
      NULL,
      1.383493,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.059210,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062434,
      2,
      2.833650,
      0.297704,
      5,
      NULL,
      NULL,
      NULL,
      1.713375,
      0,
      1,
      0.171299,
      0.028893,
      1,
      1,
      NULL,
      1.468545,
      0,
      0,
      NULL,
      1.221847,
      1,
      1,
      1.092304,
      0.325134,
      NULL,
      0,
      1,
      0.479674,
      1.086259,
      NULL,
      1.075334,
      0,
      0,
      0,
      0.640723,
      NULL,
      2,
      4,
      4.880123,
      0,
      6.838556,
      0,
      7.000969,
      NULL,
      0,
      1,
      1.438420,
      0,
      0,
      1,
      2.573836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345814,
      0.861515,
      0,
      1,
      NULL,
      0.909306,
      0.857578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.935169,
      1.539017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.757893,
      1,
      2,
      1.971540,
      NULL,
      NULL,
      NULL,
      0,
      3.519930,
      0.835158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.774777,
      1,
      0,
      0.975630,
      NULL,
      0,
      NULL,
      1.189437,
      0.363461,
      0,
      0,
      NULL,
      0.343713,
      0,
      NULL,
      1.624232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.399620,
      '04131',
      '10211',
      NULL,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.373016,
      3.371797,
      0.829361,
      2,
      3.488810,
      3.838404,
      1.232385,
      NULL,
      NULL);
commit;
end;
/


