set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      NULL,
      NULL,
      25,
      '3004242',
      40.277999,
      5,
      0.811197,
      3,
      '210231',
      3.127110,
      ' 6- 8-1977',
      1.977894,
      43,
      NULL,
      NULL,
      5.689599,
      1,
      NULL,
      NULL,
      1.992685,
      3.316512,
      1,
      1.885394,
      NULL,
      1,
      7,
      0.294482,
      1,
      2.046395,
      1.714205,
      5.600771,
      7.011127,
      0,
      1,
      1.667480,
      NULL,
      NULL,
      1.346227,
      1,
      3,
      2.753852,
      2.590704,
      0.666606,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.395888,
      1,
      1.072165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034807,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.306686,
      0,
      3,
      4,
      0.093955,
      NULL,
      1.197559,
      0,
      0,
      NULL,
      NULL,
      0.815035,
      0,
      1.281761,
      1,
      NULL,
      NULL,
      1.175353,
      NULL,
      1,
      1.174523,
      0,
      1.206213,
      0,
      1,
      0,
      0.953301,
      NULL,
      1.206820,
      1,
      1,
      1.343385,
      NULL,
      NULL,
      NULL,
      0,
      6.733312,
      6.103183,
      8,
      3,
      7.859209,
      2,
      7,
      9,
      0.010324,
      0,
      NULL,
      3,
      0,
      0,
      5.719760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.727933,
      1.821148,
      NULL,
      0,
      NULL,
      0,
      0.440934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.946826,
      3,
      1,
      1.776901,
      1.691194,
      3.344115,
      1.863629,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.331866,
      2.404813,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.767700,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135097,
      3,
      2.009609,
      0,
      2,
      1,
      1,
      NULL,
      1,
      1.760407,
      1,
      0,
      1.577325,
      0.736592,
      0.241711,
      NULL,
      0,
      0,
      1.896502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10203',
      '34220',
      '',
      1.040712,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4.553521,
      0,
      NULL,
      2,
      2,
      1,
      0,
      1,
      0);
commit;
end;
/


