set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21323033',
      NULL,
      55,
      '4133340',
      25,
      6,
      1.150461,
      NULL,
      '301334',
      4,
      ' 8-13-1980',
      14.812790,
      30.293427,
      1,
      NULL,
      NULL,
      0.001191,
      NULL,
      NULL,
      0,
      1.589324,
      0.850285,
      0.003376,
      0,
      0,
      6.016056,
      1,
      1,
      3,
      1.460362,
      3,
      5.977377,
      0,
      NULL,
      1,
      1,
      1.543728,
      6,
      1,
      4,
      NULL,
      2,
      1.148240,
      NULL,
      NULL,
      0.046825,
      NULL,
      NULL,
      NULL,
      0.704188,
      1,
      0.425788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639531,
      0.737064,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.891087,
      1.060223,
      1.065813,
      NULL,
      1,
      1,
      1.751661,
      0.650589,
      0.815192,
      1.283872,
      0.028452,
      1,
      1,
      NULL,
      0,
      1.391401,
      1,
      NULL,
      1.862757,
      0.055446,
      0.732956,
      0,
      NULL,
      1.886918,
      0.135171,
      3.402158,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.420780,
      0.753318,
      1,
      0,
      3.489222,
      4.717323,
      4,
      NULL,
      1.801259,
      7,
      1.822201,
      1.476481,
      0.329629,
      2.250490,
      1.486938,
      1.632056,
      2,
      0.476714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093489,
      NULL,
      0,
      0,
      0.109289,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.110309,
      1,
      0.680196,
      0.201830,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.971192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068690,
      2.896570,
      1,
      0.650336,
      0,
      1.331966,
      2.478670,
      1,
      1.422015,
      0,
      0.092894,
      1.049334,
      NULL,
      NULL,
      0,
      1,
      0,
      0.331325,
      0,
      1.290431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '40111',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      0,
      1.217723,
      1.035773,
      NULL,
      1,
      1.949574,
      3.592621);
commit;
end;
/


