set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      NULL,
      42.894943,
      28,
      '3140313',
      95.407738,
      2,
      2.004616,
      0,
      NULL,
      2,
      NULL,
      37,
      7.282266,
      1.315012,
      NULL,
      1,
      0.122424,
      0,
      NULL,
      0.470586,
      0.810141,
      NULL,
      1,
      0.306921,
      1,
      6,
      1.677461,
      1,
      1.558442,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      4.921715,
      0,
      NULL,
      0.365407,
      0.190460,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.889270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.999822,
      0.965833,
      NULL,
      NULL,
      1.474632,
      0,
      0.562559,
      1,
      0.516329,
      1,
      1,
      0,
      0.845086,
      0,
      NULL,
      1.822961,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.164998,
      0.417041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.890423,
      NULL,
      7,
      5,
      6.143326,
      5.603107,
      NULL,
      NULL,
      NULL,
      4.547139,
      2,
      NULL,
      3,
      1,
      0,
      1.995154,
      1.079143,
      1.852262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068572,
      NULL,
      NULL,
      0,
      1.696446,
      NULL,
      1,
      1.698408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.610110,
      NULL,
      4,
      0.486280,
      1,
      1.898373,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.258196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995896,
      0.102004,
      3,
      0,
      1,
      0.992522,
      0,
      NULL,
      1.400080,
      2.403043,
      1.325979,
      0,
      0,
      0,
      1.780140,
      1.743065,
      NULL,
      1.043885,
      0.506425,
      0.612554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871452,
      '23131',
      '30231',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      5,
      2.150090,
      2.427523,
      1,
      0,
      2.545595,
      3.035757,
      1,
      0);
commit;
end;
/


