set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '34230424',
      NULL,
      22,
      '1240402',
      81.643053,
      3,
      NULL,
      1,
      NULL,
      6.114443,
      ' 1-14-1997',
      17.975020,
      NULL,
      1.421248,
      NULL,
      0,
      0.947182,
      0.026461,
      0.034302,
      0.528011,
      NULL,
      0,
      1,
      3,
      1.865843,
      7.654536,
      1,
      0,
      1,
      0,
      1.812392,
      2,
      1.338748,
      1,
      5,
      NULL,
      NULL,
      1.556305,
      0,
      NULL,
      2.255437,
      3,
      NULL,
      NULL,
      NULL,
      0.841786,
      NULL,
      NULL,
      1.482107,
      1.162771,
      0.084842,
      0.235783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.239473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170071,
      0.036375,
      1,
      1,
      1.869400,
      1.442604,
      0.835182,
      1,
      1,
      NULL,
      1.963489,
      0.795032,
      0,
      1.677118,
      NULL,
      0.271355,
      0.004401,
      0.516226,
      1,
      NULL,
      NULL,
      1.130539,
      0.942602,
      0.995214,
      1,
      1,
      1,
      3.694904,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467284,
      0.314316,
      0,
      1.408864,
      0,
      3,
      9.272457,
      5.061728,
      7,
      6.102876,
      6.730458,
      0,
      NULL,
      NULL,
      1.365945,
      NULL,
      NULL,
      NULL,
      1,
      2.076239,
      1.854649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785561,
      0,
      0,
      1,
      0.796076,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.489863,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.427316,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516491,
      1,
      0.576271,
      0,
      NULL,
      1,
      1.146356,
      NULL,
      NULL,
      NULL,
      1.311254,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.517600,
      0.455936,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.896263,
      3,
      1,
      1,
      1.426947,
      NULL,
      0,
      1.325258,
      1.032614,
      0.886862,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.259887,
      NULL,
      '14140',
      '',
      0.313602,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      2,
      2.867942,
      0,
      2.188498,
      3,
      2,
      2.676781,
      NULL,
      2);
commit;
end;
/


