set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      21,
      9,
      '4443244',
      92,
      NULL,
      0,
      3,
      '133204',
      4,
      ' 8-10-1981',
      32.419039,
      2.656400,
      1.191816,
      NULL,
      0.444315,
      1,
      2,
      NULL,
      0.297463,
      0.867411,
      0.691081,
      NULL,
      2,
      1,
      9.607561,
      1.515135,
      0.431584,
      0,
      0,
      5.616905,
      NULL,
      0,
      6,
      9,
      6.939142,
      6,
      3.120850,
      1,
      2,
      1.883798,
      2,
      0,
      NULL,
      NULL,
      1.381947,
      NULL,
      NULL,
      0.124952,
      0.199053,
      1.811152,
      1.050995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656459,
      0.854144,
      0,
      0.096194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384313,
      NULL,
      NULL,
      1,
      1.351341,
      NULL,
      1,
      NULL,
      1,
      1.243244,
      0,
      NULL,
      0.100656,
      NULL,
      NULL,
      0.876186,
      0.778056,
      NULL,
      0,
      NULL,
      0,
      1,
      1.272142,
      1.893399,
      1.622569,
      1,
      0.183102,
      0.002049,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385269,
      NULL,
      0.503547,
      1.797017,
      0,
      3,
      7,
      2,
      1.364743,
      4.381713,
      3,
      NULL,
      7.309605,
      3.496790,
      4.794491,
      1,
      1.706870,
      1.727321,
      NULL,
      9.478261,
      1.192593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.350251,
      0.065843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.910981,
      1.534628,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.508427,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050525,
      1,
      1.852715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.398391,
      2,
      3.514250,
      1,
      1.947199,
      0,
      1,
      0,
      NULL,
      0.793588,
      NULL,
      0,
      1.802917,
      1.628557,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.118648,
      '10201',
      '44302',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.276433,
      0.851585,
      NULL,
      2,
      NULL,
      NULL,
      0.100841,
      1,
      NULL);
commit;
end;
/


