set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31314133',
      58,
      25.685851,
      '0431002',
      87.307050,
      6,
      3,
      NULL,
      '441114',
      0.831027,
      ' 1-29-1988',
      36,
      17,
      0,
      NULL,
      NULL,
      0,
      3.188227,
      NULL,
      NULL,
      NULL,
      0.122298,
      0.944962,
      3,
      NULL,
      3,
      0.567047,
      1,
      0,
      1.787539,
      0,
      1,
      NULL,
      4.612691,
      3,
      5,
      0.677433,
      3.590518,
      1,
      0,
      3,
      2.299178,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.526566,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632165,
      1.761848,
      0.623779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522068,
      0.353104,
      0,
      1,
      NULL,
      0.578725,
      NULL,
      0,
      0,
      1,
      0.706083,
      1.494104,
      0.486827,
      1.249524,
      NULL,
      1.456919,
      1.255979,
      NULL,
      NULL,
      NULL,
      1.322524,
      NULL,
      1,
      0.060344,
      1.895570,
      NULL,
      0,
      2.948427,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.530362,
      0,
      0,
      NULL,
      1.775947,
      NULL,
      2.936972,
      1,
      2,
      0.066227,
      8,
      3,
      NULL,
      2.608439,
      3,
      3.568175,
      0.617768,
      1,
      9.671613,
      1.564056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.978893,
      0,
      NULL,
      1.719684,
      1.690261,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034588,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.606900,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.726138,
      NULL,
      1.562946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.699442,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446946,
      1,
      3.230890,
      0,
      0,
      0.728248,
      0,
      0.276339,
      1,
      NULL,
      0,
      1.123669,
      1,
      1.181152,
      1,
      1.498816,
      0,
      NULL,
      1.639024,
      1.239394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '02140',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      0.333969,
      3,
      NULL,
      0,
      3,
      0.514017,
      2.966454,
      1);
commit;
end;
/


