set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '31',
      15,
      5.144471,
      '0412404',
      0.329022,
      NULL,
      2.201882,
      NULL,
      NULL,
      2,
      ' 4-11-1986',
      50,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      0.389775,
      1,
      1,
      1.166904,
      0.158504,
      1.964109,
      NULL,
      0,
      0.442719,
      NULL,
      1.688678,
      3.283751,
      3,
      2,
      1.898200,
      5,
      0,
      6,
      1.638998,
      1,
      1,
      3.397997,
      3.321900,
      0.089989,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.942265,
      NULL,
      0.127879,
      NULL,
      2,
      0.109429,
      0.638344,
      0.115271,
      3,
      0,
      2.819274,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.359428,
      0.298718,
      1.924322,
      1,
      1,
      NULL,
      1,
      2,
      0.153331,
      NULL,
      NULL,
      NULL,
      0.345450,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      0.083532,
      1,
      0.825067,
      0.205745,
      NULL,
      0.698029,
      0.538501,
      1,
      1,
      0.633696,
      0,
      NULL,
      0,
      0,
      NULL,
      1.936833,
      2.016774,
      1,
      2.467100,
      1,
      NULL,
      3.739992,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.697555,
      0.195889,
      NULL,
      2.146103,
      NULL,
      1.728453,
      NULL,
      0.060863,
      7.133323,
      0,
      1,
      1.264037,
      9,
      0,
      0.418825,
      NULL,
      3.523112,
      NULL,
      0,
      NULL,
      1.641915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.276855,
      0,
      0,
      NULL,
      1.587102,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.656360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.017749,
      3.831528,
      4,
      5,
      NULL,
      1.173682,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087293,
      NULL,
      3,
      1,
      NULL,
      0.475507,
      0.404623,
      2.401509,
      0.989324,
      1,
      NULL,
      0,
      0.929716,
      0.738586,
      NULL,
      1,
      0.076272,
      NULL,
      1.249804,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '43030',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4.066189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


