set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00',
      4.942835,
      NULL,
      '0034331',
      18,
      NULL,
      1.898300,
      1,
      '040233',
      2,
      '10- 8-2002',
      2,
      108,
      0,
      NULL,
      0.989194,
      1,
      3,
      0.311207,
      1,
      1.524645,
      1.739306,
      0,
      0,
      1.629300,
      4.956477,
      0.539629,
      0,
      0,
      6,
      3,
      NULL,
      1,
      5.702975,
      1.899719,
      6.039950,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.745930,
      0.697993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      4.234623,
      NULL,
      3,
      NULL,
      1.270850,
      0,
      1,
      3.223022,
      0,
      3.021521,
      1,
      1,
      1,
      0.636010,
      1,
      3,
      0,
      5.965731,
      0,
      1,
      7.480133,
      1,
      1,
      1.499060,
      1.234917,
      NULL,
      NULL,
      1.034903,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.285579,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      5.633688,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.092988,
      0,
      4,
      4.408009,
      NULL,
      6.232643,
      5,
      1,
      1.205817,
      4.023709,
      1.978925,
      NULL,
      5.038074,
      NULL,
      1.116520,
      NULL,
      0.103283,
      9.397368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377235,
      1.146160,
      0,
      0,
      0.309901,
      0.981872,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970349,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.177034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.601681,
      5,
      0,
      0.764514,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633562,
      NULL,
      2,
      0,
      0,
      1.031570,
      2.721944,
      0,
      0.459630,
      2.164359,
      2,
      0.982434,
      1,
      NULL,
      1.732431,
      1.421078,
      0.759002,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '23044',
      '',
      '',
      1.036411,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      2.680426,
      3.990847,
      0.429838,
      0,
      1,
      0,
      1,
      3);
commit;
end;
/


