set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      NULL,
      30.315797,
      49.037169,
      '4224141',
      9.596997,
      0,
      2.106780,
      NULL,
      '420422',
      6,
      '10- 1-1998',
      15.596683,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.834989,
      0.103859,
      0.712496,
      1.291930,
      NULL,
      NULL,
      1.020284,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.095257,
      NULL,
      4,
      NULL,
      1.620373,
      0.995297,
      1,
      0,
      4.563410,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.172932,
      NULL,
      NULL,
      2.439200,
      3,
      4,
      2.224394,
      3,
      3.983853,
      1.007822,
      3,
      0.614260,
      2.963803,
      1.477734,
      0,
      1,
      0,
      0.208059,
      2,
      0,
      NULL,
      0.752482,
      NULL,
      1,
      0.357156,
      2.151942,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.562070,
      NULL,
      NULL,
      0,
      1,
      0.260029,
      1,
      0,
      1,
      NULL,
      0.929980,
      NULL,
      1,
      0,
      0.497897,
      NULL,
      1,
      1,
      0,
      0.090460,
      1,
      0,
      NULL,
      NULL,
      0,
      1.522637,
      4.344227,
      0,
      0,
      1.568227,
      1.877145,
      1,
      0,
      1.415046,
      NULL,
      0.920841,
      0.172808,
      NULL,
      0,
      NULL,
      3,
      6.246107,
      2,
      7.120628,
      3,
      0.260836,
      2.856645,
      3.413198,
      NULL,
      2.010125,
      1.516623,
      1.282390,
      1.023002,
      1.926717,
      7.388027,
      0.064799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.138629,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.007338,
      1,
      NULL,
      NULL,
      9.826355,
      2.619243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843860,
      0,
      0.387878,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.032687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.179176,
      NULL,
      2,
      0,
      0.267282,
      1,
      1,
      1,
      0.062157,
      0.271495,
      1.466365,
      1,
      0.787931,
      0,
      0.612572,
      0,
      0.569214,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.204496,
      '00241',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.261474,
      NULL,
      '',
      '',
      2.963163,
      3,
      NULL,
      0.995722,
      2,
      1.791054,
      NULL,
      2,
      1);
commit;
end;
/


