set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '44430232',
      29.188251,
      2,
      NULL,
      10.425574,
      3,
      NULL,
      3,
      '224333',
      1,
      ' 5-29-1999',
      63.542853,
      NULL,
      0.457260,
      NULL,
      1.465622,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.793943,
      0.644419,
      0,
      4.357766,
      1.678820,
      0.509109,
      0.835024,
      0,
      2,
      4.638122,
      0.660674,
      4.158579,
      0,
      0,
      1,
      3,
      NULL,
      0,
      1,
      2.369929,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.183773,
      2.527670,
      2,
      2.187496,
      0,
      1.999055,
      2.083229,
      NULL,
      0,
      0.573587,
      0.686848,
      1.201119,
      0,
      1.377947,
      1.528535,
      1,
      NULL,
      1.140314,
      NULL,
      2.114535,
      NULL,
      0.189145,
      1.614446,
      NULL,
      0,
      2.918953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503265,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265434,
      0.729002,
      1.531278,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1.790864,
      NULL,
      NULL,
      1.230450,
      1.678241,
      0.180087,
      NULL,
      NULL,
      0,
      5,
      0,
      0.071653,
      NULL,
      1,
      NULL,
      0.787847,
      0,
      1.998921,
      1.036076,
      1.970410,
      6.255362,
      NULL,
      6.244106,
      NULL,
      NULL,
      1.045715,
      0,
      NULL,
      0,
      0.287194,
      NULL,
      0,
      1,
      1.683136,
      5,
      1.838246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.045514,
      1,
      3.152311,
      NULL,
      NULL,
      1,
      5,
      2.906050,
      1.151196,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3.605275,
      7.481442,
      1.804312,
      1,
      0.147777,
      NULL,
      NULL,
      NULL,
      0.336640,
      2.159579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      0.176215,
      1,
      1,
      0.983354,
      2,
      0.405296,
      1.017470,
      0,
      1.627512,
      0.754838,
      1.774980,
      1.561275,
      NULL,
      0.957942,
      1.114585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.346047,
      1.422797,
      NULL,
      0.919810,
      1,
      0,
      0,
      3,
      '02031',
      NULL,
      '',
      1.817416,
      '',
      '',
      '',
      0.128744,
      NULL,
      '',
      '',
      3.025794,
      2,
      2.825848,
      3.091666,
      NULL,
      3,
      0,
      3.835247,
      0.353346);
commit;
end;
/


