set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '102',
      NULL,
      15,
      53,
      '2121241',
      51.751330,
      4,
      NULL,
      3,
      NULL,
      6,
      ' 4- 6-1980',
      38,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.997404,
      1.177822,
      NULL,
      1,
      0.816066,
      2.340403,
      0.781152,
      0,
      NULL,
      0,
      2.142678,
      NULL,
      0.043580,
      1.827178,
      NULL,
      0,
      1,
      0,
      2,
      0.157720,
      2.699814,
      0,
      0.489241,
      2,
      3,
      1.634163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.075707,
      NULL,
      1,
      0.785111,
      0.996810,
      0.024758,
      0,
      NULL,
      NULL,
      1,
      2.572137,
      1.039154,
      NULL,
      3,
      1,
      NULL,
      3,
      1.100472,
      2,
      0,
      1.762209,
      NULL,
      6,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.579368,
      0,
      0.776327,
      NULL,
      1,
      1.488653,
      1,
      NULL,
      NULL,
      0.751008,
      0,
      1.678758,
      0,
      0,
      0.539514,
      1.575766,
      NULL,
      NULL,
      0.603335,
      NULL,
      0,
      0,
      1,
      0.528695,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.232670,
      0,
      1.071732,
      0,
      1.737333,
      5,
      7,
      4.204330,
      0.811984,
      0,
      7.980213,
      1.062628,
      5.104377,
      NULL,
      2,
      NULL,
      1.253703,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090858,
      NULL,
      0,
      1,
      NULL,
      1,
      0.857468,
      0.445926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.758893,
      3.955576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.425577,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.560373,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.375370,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.041175,
      2.428111,
      3.982870,
      1.232520,
      2,
      0.114286,
      0,
      1,
      2,
      3.058311,
      0.881852,
      0,
      1.888813,
      1.980379,
      0,
      0,
      1,
      0,
      1.104970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.700194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442157,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.499013,
      0,
      1,
      NULL,
      '00404',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.174077,
      '',
      '',
      NULL,
      2,
      3,
      2,
      NULL,
      1,
      2,
      2.338109,
      0,
      1.797798);
commit;
end;
/


