set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '14012302',
      NULL,
      19.547356,
      '2422123',
      93.048622,
      NULL,
      2.467783,
      2,
      '114402',
      0,
      NULL,
      56,
      124,
      NULL,
      NULL,
      0.708361,
      0,
      2.044604,
      0.439174,
      0,
      1,
      1.446399,
      3.394537,
      NULL,
      1.102439,
      0,
      0,
      3.505291,
      0,
      1.537002,
      0,
      5,
      NULL,
      2,
      0.079947,
      0.988047,
      1.873138,
      7.909254,
      1,
      NULL,
      2,
      1.082206,
      0.776201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      1.480412,
      1,
      NULL,
      2.376096,
      0,
      1,
      2.033949,
      NULL,
      1.306812,
      NULL,
      NULL,
      1,
      NULL,
      0.720057,
      NULL,
      1,
      NULL,
      0.360839,
      NULL,
      5,
      1,
      0,
      NULL,
      0.798077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034863,
      1,
      NULL,
      0,
      2.961614,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.544051,
      NULL,
      0.225772,
      1.835250,
      0.973656,
      0,
      0,
      NULL,
      NULL,
      0.868476,
      NULL,
      NULL,
      0.976301,
      1.972308,
      NULL,
      1.417681,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.652187,
      1,
      1,
      0.784417,
      5,
      0.132289,
      4,
      2.719769,
      1.496274,
      NULL,
      4.288014,
      NULL,
      NULL,
      1.524499,
      NULL,
      3,
      NULL,
      0.132820,
      8.937133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.913487,
      NULL,
      0,
      1.812565,
      0,
      0.771984,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004650,
      0,
      0,
      0,
      3.602602,
      0,
      1.266350,
      0,
      NULL,
      NULL,
      NULL,
      3.184552,
      NULL,
      NULL,
      NULL,
      0.258274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302827,
      3.296391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663277,
      3.334563,
      NULL,
      NULL,
      NULL,
      0.415889,
      0.554793,
      NULL,
      NULL,
      1,
      NULL,
      0.919445,
      0.560150,
      1,
      0,
      1.857372,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '03000',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.203138,
      '',
      '',
      NULL,
      2.349328,
      NULL,
      2.927552,
      3.108717,
      NULL,
      3.401115,
      NULL,
      2.459982,
      5);
commit;
end;
/


