set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1001',
      '03020132',
      30,
      55.479100,
      '3044323',
      NULL,
      0,
      NULL,
      1,
      '304040',
      NULL,
      NULL,
      15.850081,
      54,
      1.209103,
      NULL,
      14.167592,
      2,
      NULL,
      0,
      3.402374,
      0.033789,
      0,
      NULL,
      0.135043,
      NULL,
      NULL,
      NULL,
      4,
      0.963350,
      0.024636,
      1.013867,
      0,
      1.026888,
      1.078626,
      NULL,
      1.890872,
      1,
      NULL,
      NULL,
      0.116536,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.678377,
      1,
      NULL,
      1,
      2,
      1,
      1,
      2.418217,
      0.615426,
      1.720702,
      2,
      NULL,
      NULL,
      NULL,
      2.653787,
      3,
      0,
      NULL,
      1,
      5.049542,
      1,
      NULL,
      2.469236,
      1.072488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0.827587,
      0.020162,
      0,
      0,
      1,
      1,
      1.043810,
      0.274496,
      NULL,
      NULL,
      1.376404,
      0,
      1,
      1.345594,
      NULL,
      NULL,
      1.876006,
      1.541622,
      1.655957,
      0,
      1.516031,
      1,
      1.588757,
      0,
      1.752495,
      NULL,
      1.000869,
      0.706980,
      1.849192,
      0,
      0.824657,
      NULL,
      0,
      NULL,
      6,
      NULL,
      5.232177,
      0,
      3,
      6.432134,
      1.533736,
      NULL,
      1,
      1,
      NULL,
      1.070997,
      0,
      0,
      1.414489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910090,
      NULL,
      1,
      NULL,
      0.203791,
      NULL,
      1.624927,
      0.499420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.311003,
      3,
      0.453412,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938486,
      NULL,
      8,
      0.680100,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468696,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457246,
      0,
      NULL,
      1.536005,
      0.435069,
      1.133799,
      1.034674,
      0.054787,
      0,
      2.604668,
      1.929288,
      0.817130,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1.611841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '13242',
      NULL,
      '',
      1.068808,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1.956660,
      2.539945,
      NULL,
      1.563540,
      3,
      0.140122,
      0.241815,
      2.375193,
      0);
commit;
end;
/


