set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34202140',
      NULL,
      71.553598,
      '0141110',
      58,
      1,
      NULL,
      1,
      '432230',
      4.184231,
      NULL,
      11,
      7,
      1.940923,
      NULL,
      1,
      0.347469,
      0.749908,
      0.735136,
      0.934926,
      1,
      0,
      NULL,
      1.912844,
      1,
      3,
      NULL,
      2.469649,
      0,
      1.143328,
      1,
      1.276120,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.093755,
      0,
      0,
      1,
      1.914779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.635006,
      NULL,
      NULL,
      0.240538,
      1.882941,
      3,
      3,
      0.879688,
      3.894801,
      3.574580,
      NULL,
      1.416974,
      0,
      1.820750,
      NULL,
      1,
      0.545278,
      NULL,
      NULL,
      0,
      0.204515,
      5.753429,
      0,
      NULL,
      0.091764,
      1.217532,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.731556,
      1.987641,
      1,
      NULL,
      0.933020,
      1,
      0,
      1,
      1.294463,
      NULL,
      NULL,
      1.938433,
      1.275721,
      1.100712,
      1,
      0,
      NULL,
      1,
      1.093503,
      NULL,
      NULL,
      1.160278,
      1.021267,
      1.176867,
      0.942941,
      1,
      0.023734,
      0.719722,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.078689,
      NULL,
      1,
      4,
      4.701994,
      1.128325,
      NULL,
      7.770988,
      1,
      1.907938,
      3,
      NULL,
      4.513310,
      0,
      NULL,
      2,
      1,
      NULL,
      9.171214,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.905752,
      1,
      NULL,
      1,
      1.344263,
      0,
      0.903222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5.345455,
      0.892654,
      5.591610,
      5,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.756101,
      5,
      0.454736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.334122,
      3,
      0.893970,
      1.739025,
      0.014482,
      0,
      0.635653,
      0.796929,
      1.188723,
      1,
      NULL,
      1.712293,
      NULL,
      1.770467,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      0.498524,
      '',
      '',
      '',
      1.706415,
      '',
      '',
      '',
      NULL,
      NULL,
      3,
      2,
      0.925102,
      2.337950,
      2.436504,
      1,
      NULL);
commit;
end;
/


