set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3302',
      NULL,
      NULL,
      84.642540,
      '1342221',
      NULL,
      NULL,
      2.160026,
      0,
      '402113',
      3,
      '11-19-1984',
      6,
      33,
      0.218136,
      NULL,
      0.476627,
      1,
      1.200358,
      0.167125,
      0,
      1.668605,
      0.250755,
      2.817122,
      NULL,
      0.852209,
      3.368148,
      0,
      2.424960,
      0,
      0,
      0.008488,
      NULL,
      0.473279,
      1.329109,
      1.162299,
      NULL,
      0.098668,
      0,
      1,
      1.392254,
      NULL,
      NULL,
      1.749465,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.596494,
      0.876554,
      NULL,
      0.594078,
      NULL,
      1.424840,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.712215,
      0,
      0.840243,
      0,
      1.489838,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.733581,
      1.374180,
      NULL,
      NULL,
      1,
      NULL,
      1.977443,
      1.605903,
      0,
      1,
      0,
      0.344384,
      0.500495,
      0,
      0,
      1.408800,
      0,
      NULL,
      0,
      NULL,
      0.877315,
      1,
      0,
      1,
      0,
      1,
      1,
      0.575010,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.061872,
      1.789934,
      0.735111,
      3.115012,
      6,
      6,
      5.305982,
      NULL,
      5.908834,
      5.087889,
      2,
      1.699875,
      0,
      NULL,
      3.710423,
      1.379972,
      0.937406,
      1,
      1.402809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.914351,
      1.110758,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524094,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.555188,
      0.288821,
      1.406793,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      4,
      0.580792,
      0,
      0.648691,
      NULL,
      NULL,
      NULL,
      NULL,
      2.840489,
      1.768797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203695,
      1,
      2.032816,
      3,
      2.492037,
      NULL,
      1,
      1.413430,
      NULL,
      1,
      0,
      NULL,
      0.620885,
      1.298530,
      NULL,
      0,
      1.071436,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.060297,
      NULL,
      1,
      1,
      0.839075,
      1,
      2.410070,
      '12222',
      '',
      '',
      1.091626,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      1.923542,
      NULL,
      1.733465,
      NULL,
      3,
      3.150176,
      2,
      0);
commit;
end;
/


