set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4421',
      '32424110',
      NULL,
      NULL,
      '2424001',
      64.273444,
      3,
      NULL,
      NULL,
      '100144',
      NULL,
      ' 5-12-1978',
      50,
      NULL,
      1,
      NULL,
      1.285585,
      0,
      0.960141,
      0,
      0.891684,
      1.682089,
      NULL,
      NULL,
      0,
      0.492744,
      2,
      1,
      1,
      0.818196,
      0,
      0.843425,
      4,
      1,
      NULL,
      1,
      0.300862,
      0,
      5.004713,
      0,
      2.812279,
      1.301518,
      1,
      0.267336,
      NULL,
      NULL,
      0.755210,
      NULL,
      NULL,
      1.468838,
      0.793509,
      3,
      1.258214,
      NULL,
      1,
      1.716699,
      1.315327,
      1.390904,
      3.285196,
      3,
      0,
      3.136567,
      2.497410,
      1,
      0,
      0.846061,
      3,
      0.247065,
      0.309081,
      0.431798,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.971371,
      0,
      1,
      1.834339,
      1.095514,
      1,
      0.977186,
      0,
      1,
      1,
      1,
      0.169743,
      NULL,
      1.568482,
      0.828875,
      NULL,
      1.171524,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      3.839082,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.073592,
      0,
      1.570565,
      4,
      1.350230,
      NULL,
      5,
      1,
      0,
      1,
      0,
      0,
      0.066839,
      4.206583,
      2,
      1.804813,
      0,
      0,
      9.110549,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399171,
      NULL,
      0,
      0.676499,
      1.173933,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859123,
      NULL,
      1.996003,
      NULL,
      NULL,
      NULL,
      3,
      0.035355,
      0,
      NULL,
      0.836055,
      0,
      0.835995,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      3,
      0,
      0.985311,
      1.785873,
      1.071065,
      2,
      3.572094,
      0.498546,
      1.537942,
      NULL,
      0.447141,
      1.943477,
      1,
      1.489001,
      1.343474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.633016,
      1.331081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151744,
      1,
      NULL,
      1.104162,
      1.292703,
      0,
      1,
      2,
      '04110',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.911346,
      NULL,
      NULL,
      NULL,
      5.456000,
      1.748983,
      1.434428,
      NULL,
      1,
      1,
      1,
      0.886848,
      0);
commit;
end;
/


