set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      16.505802,
      NULL,
      '3322341',
      11,
      NULL,
      1.479359,
      0,
      '214243',
      3.017618,
      NULL,
      NULL,
      71,
      1,
      NULL,
      0.785470,
      1.244634,
      2.735354,
      NULL,
      1,
      0,
      0.135618,
      1,
      3.482312,
      0.005538,
      NULL,
      NULL,
      2,
      1.932280,
      0,
      NULL,
      3.380715,
      5,
      1,
      NULL,
      4.857908,
      2,
      6,
      1,
      5,
      NULL,
      3.174251,
      0.069412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.770292,
      1.592288,
      NULL,
      1.181648,
      1.329708,
      NULL,
      2.928295,
      NULL,
      1.527570,
      NULL,
      2,
      1.882948,
      NULL,
      NULL,
      3.895336,
      1.409429,
      0,
      1,
      1.537248,
      0,
      NULL,
      4.379232,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.162023,
      NULL,
      NULL,
      NULL,
      1.065763,
      1.999656,
      1.934585,
      1.651239,
      5.615994,
      1.286684,
      0.977968,
      1.933543,
      1.237369,
      0,
      0,
      0,
      3.020460,
      0.714008,
      0.227918,
      0.359595,
      0.840374,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.821458,
      1,
      1,
      1.736682,
      NULL,
      0,
      3,
      1,
      1.553433,
      0,
      1,
      2,
      3,
      1.938821,
      3,
      5,
      0,
      NULL,
      1,
      1,
      3,
      4,
      2,
      1,
      4,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041829,
      0.286028,
      1,
      NULL,
      0,
      0,
      1.829680,
      1.163658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.309151,
      1,
      1.614847,
      3.233389,
      5.866510,
      1.427690,
      1.393526,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.847894,
      5.298199,
      1,
      2,
      3.921504,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.596166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.708334,
      0.611004,
      0,
      NULL,
      NULL,
      NULL,
      0.653616,
      NULL,
      3,
      0,
      1.775114,
      0.115144,
      NULL,
      1.743334,
      0.488691,
      1,
      1,
      1,
      0.622527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.107905,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.140835,
      '',
      '',
      '',
      0.242221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


