set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '10',
      12,
      6,
      NULL,
      3.700244,
      0,
      3.267320,
      1,
      '030131',
      5.708725,
      ' 9-26-1986',
      17.450355,
      9,
      1,
      NULL,
      3,
      0,
      1.269506,
      0.581299,
      2.986242,
      NULL,
      1,
      1,
      2.821690,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.351355,
      NULL,
      0,
      7,
      1,
      NULL,
      0,
      NULL,
      0.577692,
      1.836491,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.854556,
      0.559006,
      0.701376,
      3,
      2,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      2.390434,
      NULL,
      1.691999,
      0,
      0,
      1,
      0.425485,
      0.348205,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.462241,
      0,
      1.117487,
      3.003507,
      NULL,
      3.871291,
      NULL,
      1,
      5,
      5,
      3.456293,
      NULL,
      0,
      0.408797,
      1,
      1,
      0.689157,
      NULL,
      NULL,
      4,
      1.632145,
      0,
      1,
      1.784039,
      1,
      0,
      0.190476,
      0.114910,
      0.557966,
      NULL,
      0.817024,
      0,
      3,
      1,
      0.071429,
      1.197089,
      0,
      NULL,
      5.429004,
      2,
      1.277231,
      6,
      NULL,
      NULL,
      7,
      3,
      6.614717,
      1,
      0.809664,
      0.213529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603402,
      1,
      1,
      1,
      1.498640,
      2.413922,
      3,
      1.485019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.039864,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3.855813,
      1,
      NULL,
      NULL,
      NULL,
      2.695450,
      NULL,
      2.831080,
      NULL,
      5.039225,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.171316,
      1,
      3,
      3,
      1,
      1,
      3,
      1.612129,
      2,
      NULL,
      0.639695,
      0.948018,
      0.794640,
      0.734309,
      0,
      0.391262,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.707282,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      3.901548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


