set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '31',
      24,
      9,
      NULL,
      12.428614,
      1,
      3,
      0,
      '220441',
      0.436860,
      ' 2-10-1993',
      63.548239,
      NULL,
      1,
      NULL,
      0.728251,
      0.378187,
      1.517132,
      NULL,
      1,
      NULL,
      0,
      1.606658,
      2,
      0,
      2.582486,
      1,
      NULL,
      3,
      0.387095,
      0,
      2.328485,
      7,
      0,
      0,
      0.804406,
      1,
      6.587602,
      1,
      NULL,
      3,
      NULL,
      1.851862,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3.378777,
      0.414705,
      0,
      0,
      2.788167,
      1.173400,
      0.883096,
      1.403870,
      1.733540,
      NULL,
      2,
      1,
      0,
      2,
      NULL,
      1.024829,
      1.865216,
      0.677522,
      0,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.621157,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      3.098106,
      1.533130,
      NULL,
      0,
      3,
      0.159714,
      0.651150,
      0.870766,
      NULL,
      1,
      1,
      0,
      1,
      5,
      1,
      4,
      0.216854,
      0.805960,
      0,
      1.996657,
      0.493789,
      0,
      NULL,
      2,
      4.020534,
      3,
      4.725798,
      0.934181,
      1.516599,
      NULL,
      1,
      4.070077,
      2,
      6.238729,
      2.335929,
      2.259541,
      NULL,
      1,
      0.383327,
      NULL,
      7,
      NULL,
      NULL,
      2,
      1.359640,
      1.772994,
      NULL,
      0.067262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229018,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4.891508,
      0.192839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1.449739,
      4,
      0,
      3.802156,
      1,
      0.984715,
      3.969476,
      3.858694,
      2.136187,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.524595,
      2.650729,
      0,
      0.549786,
      1,
      3,
      0.382235,
      NULL,
      NULL,
      0.883591,
      1.996056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594865,
      1,
      2.480470,
      3.852917,
      3,
      1,
      1,
      1,
      0.604749,
      1.887385,
      3.136463,
      1.818887,
      1.435190,
      0,
      0.434694,
      NULL,
      0,
      1.079404,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '02414',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


