set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43',
      41.360615,
      2.609729,
      '0022114',
      NULL,
      5,
      0.421185,
      NULL,
      '144324',
      0,
      NULL,
      40,
      55.190208,
      1,
      NULL,
      1.723487,
      NULL,
      1.298302,
      1,
      0.261489,
      1,
      1,
      0,
      2.716045,
      1.140698,
      1,
      0.491286,
      1,
      2,
      NULL,
      0,
      0,
      0.004797,
      NULL,
      4.904882,
      5,
      NULL,
      NULL,
      0,
      3.195953,
      1,
      0.792974,
      NULL,
      NULL,
      NULL,
      0.552362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.473307,
      1.687056,
      3.316995,
      0.376745,
      0,
      2.091795,
      NULL,
      1.649758,
      2,
      1.347279,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.941062,
      0.807467,
      NULL,
      NULL,
      NULL,
      0.611554,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.311314,
      NULL,
      0.050438,
      2,
      2,
      1.720672,
      NULL,
      1.907428,
      1,
      1,
      NULL,
      1,
      0,
      1.566342,
      1,
      1.503648,
      1.944068,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518688,
      NULL,
      NULL,
      0,
      0,
      1,
      0.167765,
      1,
      0,
      0.401058,
      1,
      0.213918,
      NULL,
      1,
      4.695699,
      NULL,
      NULL,
      3.548982,
      2.145189,
      1.694383,
      5,
      3,
      NULL,
      6.250223,
      NULL,
      7,
      1.060801,
      NULL,
      0.352301,
      5,
      1.326154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.879762,
      2,
      0,
      1.314830,
      5.014489,
      NULL,
      1.665692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017782,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514563,
      2.537052,
      1.813966,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497272,
      NULL,
      3.759976,
      5.348730,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.483487,
      1,
      NULL,
      0.945969,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11310',
      '',
      NULL,
      1.480459,
      '',
      '',
      '',
      1.222915,
      '',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


