set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11',
      9,
      NULL,
      NULL,
      43,
      5,
      1.619004,
      2,
      NULL,
      6.082403,
      ' 3-21-2003',
      NULL,
      27,
      1.592851,
      NULL,
      2,
      0,
      2,
      1,
      1.020875,
      3.968376,
      1.883243,
      1,
      NULL,
      0,
      8,
      NULL,
      0,
      NULL,
      0.312894,
      0.375870,
      0.620053,
      5,
      2,
      NULL,
      2.264721,
      1.679584,
      3.497985,
      NULL,
      NULL,
      NULL,
      3.990415,
      0.750951,
      NULL,
      NULL,
      0.051063,
      NULL,
      NULL,
      10,
      7.971882,
      2.589277,
      3.568929,
      0,
      0,
      3,
      2.810693,
      2.677399,
      1.630758,
      0.975836,
      0.502407,
      0.981917,
      1,
      NULL,
      1,
      3.351386,
      3.588825,
      NULL,
      1.342704,
      3,
      1.244936,
      4,
      1,
      0,
      3.251831,
      0.146125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.507007,
      3.570210,
      3.245810,
      2.261781,
      6.897550,
      NULL,
      0,
      1.038338,
      5.837754,
      1,
      5.504583,
      NULL,
      NULL,
      0.503758,
      0.690036,
      NULL,
      0.772807,
      0,
      NULL,
      0,
      1.747944,
      4,
      NULL,
      1,
      NULL,
      3,
      1.929881,
      1,
      1.040722,
      NULL,
      NULL,
      1.701812,
      1.358229,
      1.072944,
      4,
      0,
      0.775799,
      NULL,
      2,
      NULL,
      0,
      4,
      3.959673,
      0,
      2.002175,
      NULL,
      5,
      2,
      0.680015,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931291,
      NULL,
      1,
      1,
      0.232898,
      0,
      2.856945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.896358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026313,
      1.834332,
      5.323353,
      1,
      6,
      2,
      7.009377,
      0.945335,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759920,
      3,
      1,
      1.132214,
      NULL,
      NULL,
      1.555130,
      NULL,
      2,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.552020,
      0.774383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '42122',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL);
commit;
end;
/


