set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '41232424',
      NULL,
      52.912830,
      NULL,
      41,
      2,
      NULL,
      2,
      '104344',
      3.844988,
      ' 5-28-2000',
      111.743215,
      135.483791,
      0.883107,
      NULL,
      1,
      0,
      0,
      NULL,
      1.675261,
      1.858065,
      3,
      3.786608,
      1,
      1,
      NULL,
      1.197234,
      1.777823,
      NULL,
      NULL,
      1,
      4,
      NULL,
      5.352428,
      1,
      NULL,
      NULL,
      1.298006,
      0,
      4.604483,
      0,
      1,
      0.408174,
      NULL,
      NULL,
      1.621262,
      NULL,
      NULL,
      NULL,
      9.355413,
      7,
      1,
      NULL,
      0,
      NULL,
      3,
      2.665281,
      NULL,
      2,
      0.030272,
      3.036480,
      NULL,
      1,
      NULL,
      3.893786,
      1.990739,
      NULL,
      NULL,
      0.730633,
      NULL,
      9.669617,
      NULL,
      NULL,
      0.440627,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.476088,
      0.628971,
      4.097426,
      NULL,
      0,
      0,
      0,
      0.201860,
      4,
      1.934267,
      NULL,
      1.214107,
      0,
      0.099811,
      0.651504,
      1.081438,
      NULL,
      0,
      0,
      6,
      1.688928,
      NULL,
      1.218241,
      6.180765,
      2.687173,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.705400,
      NULL,
      2.948351,
      7,
      NULL,
      0.854030,
      7.005631,
      4.518694,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.422472,
      1,
      0,
      NULL,
      NULL,
      6,
      0.490309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.664747,
      2.507390,
      1.314588,
      0.203954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      5,
      7.930322,
      1,
      7.968340,
      0.609462,
      NULL,
      NULL,
      1,
      11,
      1.198357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019930,
      NULL,
      3,
      NULL,
      1.103122,
      2,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0.730899,
      1.659720,
      1.342554,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '43242',
      '',
      '',
      1.721708,
      NULL,
      '',
      '',
      1.563248,
      '',
      '',
      '',
      4.166448,
      1.663368,
      1.004383,
      0,
      1,
      1,
      0.438492,
      3,
      3);
commit;
end;
/


