set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '24231020',
      12.760399,
      52,
      '1102220',
      72.535608,
      1,
      0.096350,
      1,
      '400313',
      NULL,
      ' 7-16-1981',
      74.865369,
      NULL,
      0.396986,
      NULL,
      0.144285,
      0.740737,
      0.797764,
      1.084918,
      1,
      NULL,
      0.369829,
      0,
      1,
      0.560767,
      NULL,
      1,
      0,
      1.308064,
      1,
      4,
      4.154875,
      2,
      1.670986,
      NULL,
      1.317389,
      2,
      4,
      0,
      3,
      0,
      2.255311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8.947175,
      9.205963,
      0,
      2,
      NULL,
      1.554982,
      NULL,
      NULL,
      NULL,
      2,
      0.986022,
      NULL,
      1,
      1.791903,
      3.645360,
      0,
      1.458685,
      0,
      3,
      NULL,
      1.193997,
      8.535963,
      1,
      NULL,
      0.326574,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.966731,
      0.998537,
      4.899878,
      3.922158,
      2,
      0.374868,
      1,
      1.881966,
      1,
      0,
      0.116259,
      0.519118,
      0,
      NULL,
      1.085330,
      NULL,
      0,
      0.870896,
      NULL,
      0.786951,
      0.833472,
      NULL,
      NULL,
      3.542115,
      1.001597,
      4,
      1.567783,
      1,
      1.948638,
      1,
      1.685408,
      1.408177,
      NULL,
      1,
      1.303533,
      2.734650,
      9,
      NULL,
      5.047290,
      1.808625,
      NULL,
      1,
      3.822439,
      NULL,
      6,
      NULL,
      3,
      3,
      1.080502,
      NULL,
      1.810618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117080,
      0,
      0,
      1.191006,
      NULL,
      2.362145,
      1.722402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.660982,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.321832,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.136613,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641100,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.689196,
      1,
      2.230658,
      1,
      NULL,
      1.987534,
      1.620250,
      0,
      1.524364,
      NULL,
      0.677244,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904037,
      '04134',
      NULL,
      '',
      0.491118,
      '',
      '',
      '',
      1.600387,
      '',
      '',
      '',
      2.673907,
      3.298333,
      0.465031,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4.436679);
commit;
end;
/


