set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '42420403',
      26,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2,
      '101140',
      4,
      NULL,
      28.558933,
      144,
      1.252946,
      NULL,
      2,
      1.025326,
      0,
      0.329144,
      0,
      0.275856,
      1.373087,
      1.691571,
      NULL,
      NULL,
      NULL,
      0.604032,
      2,
      NULL,
      NULL,
      1,
      5.047712,
      1,
      NULL,
      0.993426,
      0,
      0,
      NULL,
      0,
      1.171409,
      1.545026,
      1.905397,
      1.695623,
      NULL,
      NULL,
      0.015053,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      1.635660,
      1,
      1.860929,
      0,
      NULL,
      0.603273,
      2,
      2.125898,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.108835,
      0,
      7,
      0,
      1,
      0.702121,
      1,
      NULL,
      NULL,
      1.902849,
      NULL,
      NULL,
      0,
      1,
      0,
      4.615728,
      0,
      4.276343,
      NULL,
      0,
      0,
      NULL,
      NULL,
      4,
      1,
      3.574654,
      1.959508,
      0.690229,
      1,
      NULL,
      1,
      NULL,
      1,
      1.143477,
      NULL,
      NULL,
      0.443663,
      1.542511,
      0,
      NULL,
      NULL,
      1,
      1,
      0.884751,
      1.321338,
      0.928736,
      1,
      4.720309,
      4,
      5,
      1.746719,
      7,
      2,
      0.840893,
      0.547916,
      3,
      3,
      2,
      NULL,
      6,
      1.619927,
      1,
      NULL,
      2.744124,
      0.448417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.195304,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001786,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.333519,
      2,
      1.424098,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.002035,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.687433,
      NULL,
      3,
      1,
      0,
      3,
      1,
      0.307402,
      0.444329,
      1,
      1,
      NULL,
      1,
      0.775404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0.804722,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.931733,
      1.771314,
      1,
      1,
      2,
      0.049640,
      1,
      13.586655);
commit;
end;
/


