set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '43211214',
      38,
      NULL,
      '0431321',
      50,
      NULL,
      3,
      2,
      '231420',
      3.551124,
      ' 8- 8-1995',
      42.686728,
      NULL,
      0,
      NULL,
      0.846117,
      1,
      0,
      1,
      1.885021,
      0.542990,
      1.326237,
      2,
      1.833925,
      NULL,
      5.284476,
      0,
      1.439868,
      0.925902,
      1,
      1.999149,
      1,
      0.719004,
      4,
      NULL,
      0,
      1,
      5.118043,
      1,
      NULL,
      0.388840,
      0.035879,
      1.663149,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      8.938807,
      2,
      0,
      NULL,
      2,
      1,
      1.382777,
      0.766104,
      1.574759,
      2.964190,
      0.764259,
      NULL,
      0.384836,
      0,
      0.830199,
      NULL,
      1.110137,
      1.529294,
      1.207885,
      1,
      1.633398,
      1.238854,
      1,
      0,
      3.950455,
      0.375164,
      NULL,
      NULL,
      0.687926,
      NULL,
      NULL,
      1.574954,
      NULL,
      0.885641,
      1,
      0.643162,
      1,
      1.901579,
      0.029273,
      1,
      0,
      0.672931,
      0,
      1,
      NULL,
      1.116609,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.615828,
      1.645668,
      1.790536,
      0.315201,
      1,
      0,
      0.238365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097093,
      0,
      0,
      0.310731,
      2.084476,
      2,
      NULL,
      1.805444,
      NULL,
      0.844060,
      5,
      0.801212,
      7.469489,
      NULL,
      1.197620,
      1,
      NULL,
      0,
      NULL,
      0,
      1.659675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685251,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508538,
      1.426729,
      3.989095,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.267872,
      NULL,
      1.578846,
      0.116305,
      1.705307,
      1,
      1.576913,
      0.799297,
      0,
      NULL,
      0,
      0.246755,
      0,
      1,
      1.115736,
      0.674133,
      1,
      0.928054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      1.539202,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      2.192692,
      2,
      0,
      1,
      1,
      2.869901,
      NULL,
      7.034718);
commit;
end;
/


