set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      NULL,
      NULL,
      56,
      '2100411',
      96,
      4,
      3,
      1,
      '440012',
      NULL,
      ' 2-15-1976',
      NULL,
      239,
      NULL,
      NULL,
      0.640664,
      2.304910,
      0.904735,
      1.413542,
      1.574230,
      0.570177,
      NULL,
      1.674032,
      1.096734,
      1.904648,
      3,
      1.685005,
      0,
      NULL,
      1,
      NULL,
      4.560660,
      NULL,
      1.968604,
      NULL,
      1,
      0.077831,
      4,
      NULL,
      NULL,
      3.730659,
      3.845462,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      9,
      3,
      0.277484,
      NULL,
      1,
      1.570203,
      1,
      NULL,
      NULL,
      0.390280,
      0,
      NULL,
      3.224124,
      0.937639,
      3,
      0,
      NULL,
      0,
      0,
      0.238919,
      NULL,
      2,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      0.523049,
      NULL,
      NULL,
      0.650777,
      0.401803,
      1.627079,
      1.266169,
      1.622556,
      0.791145,
      0,
      0,
      NULL,
      NULL,
      0.021630,
      1,
      1,
      NULL,
      0.567797,
      0.935657,
      1,
      0.933322,
      NULL,
      NULL,
      0,
      1.345800,
      NULL,
      1,
      1,
      0,
      1.880490,
      0.923509,
      1,
      1.439912,
      1.491351,
      1.031092,
      1,
      0.908636,
      NULL,
      0.971573,
      0.239968,
      1.482335,
      0,
      3.264354,
      0,
      4,
      0.472370,
      4.725910,
      4,
      1,
      0,
      NULL,
      1.049452,
      NULL,
      1.031790,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076799,
      NULL,
      1,
      0,
      NULL,
      1.296634,
      0,
      0.470367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469764,
      3,
      2,
      1,
      NULL,
      8.518249,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357687,
      0.327406,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.037355,
      3,
      1.499543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.375947,
      0.114568,
      0,
      NULL,
      0,
      0.694011,
      2,
      NULL,
      0.933502,
      0.458111,
      NULL,
      0,
      NULL,
      1.184063,
      0,
      0.311305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      0,
      2.510158,
      2,
      0,
      3.719222,
      0.181888,
      1);
commit;
end;
/


