set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '24323201',
      NULL,
      64,
      NULL,
      34,
      0,
      2,
      3,
      '124444',
      0,
      ' 7-24-1975',
      169.816670,
      NULL,
      0,
      NULL,
      1,
      1.680802,
      1,
      0,
      0.268957,
      0.602477,
      NULL,
      2.890222,
      1,
      NULL,
      1.550154,
      0,
      1.565031,
      0,
      0.364699,
      0,
      0,
      0.425411,
      4,
      NULL,
      2,
      1,
      7.816850,
      1,
      NULL,
      0.743809,
      3.984848,
      0.843109,
      NULL,
      NULL,
      0.082732,
      NULL,
      NULL,
      NULL,
      0.466994,
      10.885849,
      1,
      0,
      1,
      0.531078,
      1.154507,
      2,
      2.941122,
      NULL,
      0,
      3,
      0.582991,
      3,
      1.524704,
      2.426540,
      2.689937,
      0.275396,
      1.562136,
      1,
      1.915000,
      8.530408,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.861651,
      0,
      NULL,
      1.581964,
      4.277681,
      0,
      1.832708,
      1.289369,
      0.276306,
      1.991945,
      1,
      1,
      1,
      0.894404,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1.310517,
      0.273490,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.745889,
      1,
      0.893187,
      7.518216,
      NULL,
      3.595400,
      0,
      0,
      NULL,
      0.511583,
      6.526313,
      1,
      1,
      1.479036,
      0,
      0,
      NULL,
      0.274205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.083356,
      1,
      1.067319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464507,
      NULL,
      NULL,
      NULL,
      NULL,
      5.052502,
      NULL,
      3.495342,
      0.006799,
      0.063819,
      0.980812,
      NULL,
      3.970946,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5.349637,
      4,
      1,
      1,
      1.681162,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      2,
      0.710549,
      0,
      2,
      NULL,
      1.322916,
      2,
      3,
      0,
      NULL,
      NULL,
      0.040185,
      0,
      0.832483,
      0,
      1.975487,
      1.870879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.640274,
      '31034',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      2,
      NULL,
      NULL,
      0.390914,
      0.853075,
      3,
      0,
      NULL,
      0);
commit;
end;
/


