set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      NULL,
      64.614525,
      NULL,
      '2300214',
      91,
      2,
      0.909162,
      3,
      '203313',
      4,
      ' 0- 4-1978',
      NULL,
      97.476222,
      0.782298,
      NULL,
      1,
      0,
      0,
      0,
      0.224109,
      NULL,
      NULL,
      3.820930,
      1.853913,
      0.455787,
      4.564565,
      0,
      1,
      1.981778,
      1,
      0,
      8,
      NULL,
      3,
      3.859904,
      0,
      0,
      8.906543,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.226760,
      10.821889,
      NULL,
      3.947382,
      1.917604,
      0,
      0,
      1.537429,
      0.300567,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.731056,
      NULL,
      1,
      0.574894,
      NULL,
      0.641783,
      5.003165,
      1,
      1,
      NULL,
      1.882595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.962337,
      0.285259,
      0.502069,
      0.138711,
      4,
      0.146475,
      1.831217,
      0,
      1.574888,
      NULL,
      1,
      0,
      1,
      1.611551,
      0,
      0.551323,
      0,
      NULL,
      NULL,
      0,
      0.456487,
      0.334235,
      1.112533,
      1,
      1.572577,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.659341,
      0.901821,
      2,
      8.465429,
      3,
      3.538873,
      4.376501,
      2.447118,
      0,
      4.911797,
      NULL,
      0,
      NULL,
      1.208872,
      1,
      NULL,
      NULL,
      1.851685,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.307381,
      1,
      NULL,
      1.428595,
      0,
      0,
      0.277387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.380014,
      NULL,
      NULL,
      0,
      1.237766,
      1,
      0.620315,
      NULL,
      NULL,
      NULL,
      0,
      4.470038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.198349,
      1,
      0,
      0,
      2,
      NULL,
      0,
      0,
      0.206771,
      1.861399,
      0,
      0,
      0.693438,
      0.657848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.289515,
      NULL,
      '',
      '',
      0.317853,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.250033,
      1,
      1.786667,
      1,
      NULL,
      2.052293,
      3,
      2.884192,
      NULL);
commit;
end;
/


