set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      '20201330',
      7.903894,
      33.664412,
      '2441234',
      13.584333,
      0,
      NULL,
      NULL,
      '344040',
      1,
      ' 7-22-1986',
      NULL,
      9,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0.417055,
      NULL,
      0.058771,
      3.909919,
      0.915611,
      1,
      7.384289,
      0.346128,
      0.592013,
      0,
      0,
      1.829937,
      3,
      0.179516,
      1.850213,
      1,
      1,
      1.181762,
      9.744991,
      0,
      NULL,
      2.217103,
      3,
      0,
      NULL,
      NULL,
      1.006254,
      NULL,
      NULL,
      NULL,
      NULL,
      7.362970,
      2,
      1.209113,
      0,
      NULL,
      1,
      1,
      0.007441,
      2.315411,
      1.000485,
      2,
      0.142636,
      0.111579,
      1,
      0,
      NULL,
      0.481535,
      6.998324,
      1.738569,
      0.226587,
      0,
      1,
      1,
      5.132469,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.226971,
      5,
      5,
      0.986298,
      0,
      NULL,
      0,
      0.640471,
      NULL,
      NULL,
      NULL,
      1.315133,
      1,
      0.914955,
      1,
      0,
      NULL,
      0.288382,
      0,
      0.669025,
      1.450766,
      0.068903,
      NULL,
      1.769488,
      3.442418,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.862804,
      5,
      7,
      3,
      1,
      4,
      7,
      0,
      3,
      1,
      1,
      NULL,
      0.324398,
      1.817638,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.826823,
      1,
      1,
      0.008449,
      0,
      1.087113,
      1.554176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390875,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.870976,
      7,
      6,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006885,
      4.008840,
      0.011799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517888,
      0.636367,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.884000,
      0.307693,
      NULL,
      0.842456,
      NULL,
      1,
      0,
      0,
      0.034080,
      1.297239,
      0,
      0,
      1.854228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0.948565,
      '',
      '',
      NULL,
      1.058055,
      3.683719,
      2,
      5,
      3.021727,
      2,
      NULL,
      1,
      0.726246);
commit;
end;
/


