set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2210',
      '31022023',
      83,
      31.826204,
      '0444144',
      15.600443,
      NULL,
      2,
      0,
      '040303',
      NULL,
      ' 5-14-2002',
      40,
      247.903053,
      0,
      NULL,
      0,
      0,
      0,
      1.114316,
      0.743441,
      0.489759,
      1.172435,
      0.045382,
      0.191857,
      1,
      4,
      0,
      0,
      0,
      NULL,
      0.651626,
      9.358645,
      0,
      1,
      2.322599,
      1,
      NULL,
      1.384073,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      1,
      1.929904,
      NULL,
      NULL,
      1,
      3,
      3.357737,
      0.254750,
      2.703916,
      3,
      2,
      1,
      0.216715,
      3,
      NULL,
      NULL,
      1,
      1.670089,
      8.529874,
      1,
      NULL,
      3.088419,
      1.954781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947188,
      NULL,
      0.032780,
      1.804412,
      4,
      1,
      0,
      1,
      0,
      1,
      0.005628,
      NULL,
      0.898160,
      4.500375,
      0,
      1.047265,
      NULL,
      0,
      1.043418,
      NULL,
      0,
      0,
      1.206903,
      0,
      NULL,
      NULL,
      1.125195,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210358,
      0,
      1.041480,
      0,
      0.478342,
      6,
      3.224889,
      0.231937,
      0.469666,
      0,
      4.708379,
      4,
      NULL,
      0.068312,
      0,
      NULL,
      2.848285,
      NULL,
      1,
      NULL,
      1.862719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006304,
      0,
      1,
      NULL,
      0.162780,
      0,
      0.494020,
      0.183213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582650,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539934,
      1.457778,
      2,
      3,
      0.890710,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976506,
      1,
      3,
      2.018000,
      1.997253,
      0,
      0,
      0,
      0.883630,
      2,
      0.633933,
      0,
      NULL,
      1.878431,
      NULL,
      1,
      0,
      1.198580,
      1,
      0.582525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44301',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.034996,
      3,
      NULL,
      1,
      0,
      2.178275,
      1,
      0,
      2);
commit;
end;
/


