set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12202130',
      66.693330,
      83.149211,
      NULL,
      175,
      3,
      1.010578,
      2,
      '320123',
      NULL,
      ' 2-20-1983',
      128,
      39.103942,
      1,
      NULL,
      1,
      0,
      2.750566,
      0.178097,
      0.182598,
      NULL,
      0.226549,
      3,
      NULL,
      1.205980,
      7.964711,
      NULL,
      1.721252,
      1,
      1,
      0.260297,
      5.413232,
      3,
      0,
      NULL,
      NULL,
      1.268423,
      8,
      1,
      0.235714,
      2.953183,
      NULL,
      1.424568,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.829168,
      6.898639,
      3,
      2,
      1,
      NULL,
      2.296137,
      2,
      0,
      1,
      0.485177,
      2.070120,
      0,
      3.055836,
      0,
      0.123879,
      2,
      0.591609,
      1,
      0,
      0.668421,
      3.364030,
      NULL,
      NULL,
      2,
      3,
      0.792076,
      NULL,
      NULL,
      0.567773,
      NULL,
      NULL,
      1,
      NULL,
      1.345923,
      1.659578,
      1.393243,
      1,
      NULL,
      0.984504,
      1.798290,
      1.074924,
      NULL,
      0,
      1,
      5.976742,
      NULL,
      0,
      0,
      1.114943,
      1,
      NULL,
      0.265575,
      NULL,
      1,
      1.158093,
      1.936495,
      NULL,
      NULL,
      1.172400,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951537,
      NULL,
      NULL,
      NULL,
      2.249909,
      3,
      2.911433,
      6.119362,
      1,
      5.136405,
      1,
      2.400080,
      4.596415,
      0,
      0,
      0.471823,
      2,
      1.542656,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.933723,
      NULL,
      0.428774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.723073,
      2.076583,
      0.790499,
      NULL,
      NULL,
      NULL,
      0,
      1.860841,
      4,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.551444,
      1.287392,
      1.992069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463626,
      3,
      2.051386,
      NULL,
      0,
      1,
      3,
      1,
      1,
      0.030550,
      2,
      1.155876,
      0,
      1,
      1.287104,
      0,
      0.004705,
      1,
      0,
      1.501014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10314',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.502523,
      '',
      '',
      '',
      2,
      NULL,
      2,
      NULL,
      1.680960,
      1.681994,
      1.020929,
      3.876564,
      2);
commit;
end;
/


