set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0243',
      '33341102',
      22.396696,
      42,
      '4432123',
      150,
      3,
      0.569161,
      3,
      '412321',
      2,
      NULL,
      78.264078,
      3,
      0.676775,
      NULL,
      0,
      1,
      NULL,
      0.267086,
      1.055276,
      1.238722,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.013316,
      1,
      5.510363,
      NULL,
      NULL,
      8.050285,
      5.565253,
      6.774513,
      1.036558,
      0.295724,
      0.271208,
      7,
      1,
      1,
      3,
      1,
      1.269411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.657347,
      8.391320,
      3.170039,
      3.104273,
      0,
      NULL,
      3.554797,
      3.528364,
      NULL,
      0,
      0.997283,
      1,
      0,
      0,
      0.335710,
      0.134780,
      2,
      0.898091,
      0.334646,
      1.088184,
      1,
      0.431726,
      9.365659,
      NULL,
      NULL,
      1.426247,
      1,
      NULL,
      NULL,
      0.988382,
      NULL,
      NULL,
      NULL,
      1,
      1.674330,
      NULL,
      4.077665,
      0.871787,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      5.202623,
      1,
      1,
      1.246470,
      1.190297,
      NULL,
      NULL,
      1.409299,
      1.505630,
      NULL,
      0.799235,
      NULL,
      1.536567,
      0,
      0.742768,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039544,
      NULL,
      1.593817,
      1,
      0.713890,
      3.949101,
      2.088975,
      2,
      4.371985,
      1,
      4.305858,
      3.932681,
      NULL,
      1,
      0.522707,
      NULL,
      0,
      1,
      1.892318,
      3,
      1.705625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416687,
      1.596084,
      0,
      1,
      NULL,
      1.011926,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474703,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.153341,
      NULL,
      1.911802,
      2,
      1.454035,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877001,
      1,
      NULL,
      NULL,
      1.942063,
      NULL,
      1,
      1.990148,
      0.090209,
      NULL,
      0.254419,
      0.457972,
      1,
      0,
      0,
      0.155053,
      1.179335,
      1.851329,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.803800,
      '12241',
      '',
      '',
      1.519454,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      0.422783,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


