set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2444',
      '40243140',
      NULL,
      NULL,
      '1333322',
      200,
      1,
      0.095017,
      2,
      '211133',
      2.938126,
      '11-17-1996',
      171,
      45,
      1.895464,
      NULL,
      0.049138,
      1.176650,
      3,
      1.651506,
      0,
      NULL,
      0.150848,
      3.342106,
      1,
      0,
      NULL,
      NULL,
      1.855531,
      0,
      1.970735,
      2,
      2.314826,
      6.133125,
      NULL,
      0,
      NULL,
      NULL,
      0.669471,
      NULL,
      1.358032,
      3,
      0,
      0.712686,
      NULL,
      NULL,
      1.410703,
      NULL,
      NULL,
      NULL,
      8.733439,
      NULL,
      1.580746,
      3.302688,
      0,
      2.092932,
      1,
      1,
      3,
      3,
      NULL,
      3.408225,
      3,
      1,
      3.291034,
      0.095068,
      1,
      3,
      1,
      0.580435,
      1,
      NULL,
      0,
      NULL,
      3.278245,
      1,
      NULL,
      NULL,
      1.961209,
      NULL,
      NULL,
      NULL,
      5.077453,
      1,
      1.868863,
      2,
      NULL,
      1.007474,
      NULL,
      0.500581,
      1.251034,
      NULL,
      0.696435,
      0.459437,
      5.859683,
      0,
      1,
      0.906301,
      0.348948,
      0.121841,
      NULL,
      NULL,
      0.154602,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176107,
      1,
      NULL,
      0,
      4,
      NULL,
      7,
      NULL,
      2.289987,
      2,
      3.817737,
      0.933585,
      1.484517,
      NULL,
      0,
      1,
      1,
      0.437416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891039,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351759,
      NULL,
      NULL,
      NULL,
      NULL,
      4.634611,
      2,
      0.392968,
      NULL,
      0.866134,
      0.318785,
      1.877177,
      NULL,
      0.365497,
      NULL,
      NULL,
      NULL,
      0.644547,
      1,
      NULL,
      0.997173,
      0.935400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.467296,
      1.439422,
      1,
      2,
      0.419666,
      0.107403,
      1,
      NULL,
      1.338428,
      2,
      1.167425,
      0.936285,
      1,
      1,
      0.400841,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.809604,
      '30032',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      3.382228,
      1,
      1.182801,
      0,
      0.185493,
      0.407564,
      2,
      1);
commit;
end;
/


